# دليل تثبيت Soccer Hunter

## متطلبات الخادم
- PHP 7.4 أو أعلى
- MySQL 5.7 أو أعلى
- خادم ويب Apache أو Nginx
- تمكين الوحدات التالية في PHP:
  - PDO و PDO_MySQL
  - GD (لمعالجة الصور)
  - FileInfo
  - JSON
  - MBString
  - OpenSSL

## خطوات التثبيت التفصيلية

### 1. إعداد قاعدة البيانات
1. أنشئ قاعدة بيانات جديدة باسم `soccer_hunter` (أو أي اسم آخر تفضله)
2. أنشئ مستخدم قاعدة بيانات جديد وامنحه كافة الصلاحيات على قاعدة البيانات

### 2. تحميل وإعداد الملفات
1. قم بتحميل جميع ملفات المشروع إلى مجلد المستندات الرئيسي لخادم الويب
2. قم بتعديل ملف التكوين `config/database.php` وتحديث معلومات الاتصال بقاعدة البيانات:
   - DB_HOST: عنوان خادم قاعدة البيانات (عادة 'localhost')
   - DB_NAME: اسم قاعدة البيانات
   - DB_USER: اسم مستخدم قاعدة البيانات
   - DB_PASS: كلمة مرور مستخدم قاعدة البيانات

### 3. إنشاء هيكل قاعدة البيانات
1. قم بتشغيل سكريبت إنشاء قاعدة البيانات عن طريق استيراد ملف `setup/database.sql` في phpMyAdmin أو أي أداة إدارة قواعد بيانات أخرى
2. سيقوم هذا بإنشاء جميع الجداول اللازمة ومستخدم افتراضي للنظام

### 4. ضبط الصلاحيات
تأكد من أن المجلدات التالية لديها صلاحيات كتابة مناسبة (عادة 755 للمجلدات و 644 للملفات):
```
uploads/images/
uploads/videos/
uploads/documents/
```

يمكنك ضبط الصلاحيات باستخدام الأمر التالي:
```bash
chmod -R 755 uploads/
```

### 5. إعداد نقطة الوصول
تأكد من أن خادم الويب موجه بشكل صحيح إلى المجلد العام:
- لـ Apache: تعديل ملف .htaccess إذا لزم الأمر لتوجيه جميع الطلبات إلى index.php
- لـ Nginx: إضافة قواعد إعادة التوجيه المناسبة في ملف تكوين الخادم

### 6. اختبار التثبيت
1. قم بزيارة الموقع في المتصفح
2. سجل الدخول باستخدام الحساب الافتراضي:
   - اسم المستخدم: admin
   - كلمة المرور: admin123
3. قم بتغيير كلمة المرور الافتراضية فور تسجيل الدخول

## استكشاف الأخطاء وإصلاحها

### مشكلات شائعة:
1. **خطأ الاتصال بقاعدة البيانات**:
   - تأكد من صحة معلومات الاتصال في ملف `config/database.php`
   - تأكد من أن خدمة MySQL تعمل
   - تأكد من أن المستخدم لديه الصلاحيات المناسبة

2. **خطأ تحميل الملفات**:
   - تأكد من صلاحيات المجلدات
   - تأكد من أن حجم الملف لا يتجاوز الحد الأقصى المسموح به في PHP (تحقق من upload_max_filesize في php.ini)

3. **صفحة بيضاء أو خطأ 500**:
   - تفعيل تسجيل الأخطاء في PHP لمعرفة السبب الدقيق
   - تحقق من ملفات السجل في خادم الويب

## التحديثات
للتحديث إلى إصدار جديد:
1. قم بعمل نسخة احتياطية من قاعدة البيانات والملفات
2. استبدل ملفات النظام بالإصدار الجديد
3. قم بتشغيل أي سكريبتات تحديث قاعدة البيانات المضمنة مع الإصدار الجديد
